<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-08-06 13:48
 */
interface BillsreturnproductsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Billsreturnproducts 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param billsreturnproduct primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Billsreturnproducts billsreturnproduct
 	 */
	public function insert($billsreturnproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Billsreturnproducts billsreturnproduct
 	 */
	public function update($billsreturnproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductid($value);

	public function queryByReturnbillid($value);

	public function queryByProductno($value);

	public function queryByProductprice($value);

	public function queryByProducttotalprice($value);

	public function queryByDeleted($value);


	public function deleteByProductid($value);

	public function deleteByReturnbillid($value);

	public function deleteByProductno($value);

	public function deleteByProductprice($value);

	public function deleteByProducttotalprice($value);

	public function deleteByDeleted($value);


}
?>